close all; clear all;
% Leemos la seal de su directorio
filename='mezcla7segundos';
[x,fs1]=audioread(['../Datos/Ejemplos/' filename '.wav']);


% Remuestremos la seal de entrada a 8000 muestras/segundo.
fs=8000;
x=resample(x,fs,fs1);

% Calculamos la STFT de la seal segn la longitud de la ventana.
N=512;
Nfft=2^nextpow2(N); 
Poverl=0.5; 
Noverlap=round(Nfft*Poverl); 
Hop_samples=round(Poverl*N); 
NFrames=floor((length(x)-N+(N*Poverl))/Hop_samples); %Se calcula el numero de frames del archivo
window=hanning(N);

[S,F,T]=sg(x,Nfft,fs,window,Noverlap); %Se calcula el espectograma de la mezcla de corazn y pulmn.


% Generacin del patrn rtmico usando TNMF (T) y NNMF (N).
% Estimacin del ritmo cardiaco buscando fuera de la zona de solapamiento (0Hz-60Hz)
[times,patron]=heart_sound_detection_v3(x,fs,T,N);




subplot(111);plot((1:NFrames)*Poverl*N/fs,patron);axis xy;xlabel('Time (s)');ylabel('Amplitude');

% Nmero mximo de iteraciones
i_max=400;

% PROCESO NMF (Factorizacin no negativa de matrices) ESTNDAR.
sim_aux=0.4;
fc_aux=260;
r1_aux=0;
lambda=0.73;
bc_corazon=55;
bc_pulmon=64;
eta=10^-5;
bc=bc_pulmon+bc_corazon;
[W,H,D_kl,Y,X,n_iterations]=UNSUPERVISED_NMF(abs(S),bc,i_max,lambda,eta);



% CLUSTERING para clasificar las bases W y las activaciones H de la
% descomposicin anterior
% De esta forma se pueden explotar las caractersticas espectrales y
% temporales para discriminar entre pulmn y corazon.
Xc=zeros(size(Y));
Xp=zeros(size(Y));

% Inicializacin de parametros
fc=zeros(bc,1);
sf=zeros(bc,1);
SIM=zeros(bc,1);
SIM_activa=zeros(bc,1);

Ncor=0;
Npul=0;
% Criterios de seleccin
for m=1:bc
    X_aux=W(:,m)*H(m,:);
    [x_clustering(:,m)]=invspecgram(abs(X_aux),Nfft,fs,hanning(N),Noverlap); % Se calcula la inversa del espectograma??
    [fc(m),SIM(m),r1(m)]=Clustering(x_clustering(:,m),fs,W(:,m),N,H(m,:),patron);
    % Se calculan los 3 clusters (SC, RO, TC) para poder determinar si el sonido es del
    % corazn
    
    if SIM(m)>sim_aux && r1(m)>r1_aux && fc(m)<fc_aux; %Condicion que debe cumplir si sonido de corazn
       
        Xc=Xc+X_aux;
        Ncor=Ncor+1;
        
    else %Sonido de pulmn.
        Xp=Xp+X_aux;
        Npul=Npul+1;
    end
end

% Creamos mscaras relativas wiener para obtener los espectrogramas
% reconstruidos.
Mc= (Xc.^2)./((Xc.^2)+(Xp.^2));
Mp= (Xp.^2)./((Xc.^2)+(Xp.^2));

% Espectrograma reconstruido de los sonidos corazon
Xc_r= Mc.*S;
Xp_r= Mp.*S;

figure;subplot(311);imagesc((1:length(x))/fs,[0 fs/2],abs(S));axis xy;xlabel('Tiempo (s)');ylabel('Frecuencia (Hz)');
%subplot(412);plot(D_kl);
subplot(312);imagesc((1:length(x))/fs,[0 fs/2],abs(Xc_r));axis xy;xlabel('Tiempo (s)');ylabel('Frecuencia (Hz)');
subplot(313);imagesc((1:length(x))/fs,[0 fs/2],abs(Xp_r));axis xy;xlabel('Tiempo (s)');ylabel('Frecuencia (Hz)');

[x_c(1,:)]=invspecgram(Xc_r,Nfft,fs,window,Noverlap); audiowrite(['../Datos/Output/' filename '_HS_Out.wav'],x_c(1,:),fs);
[x_p(1,:)]=invspecgram(Xp_r,Nfft,fs,window,Noverlap); audiowrite(['../Datos/Output/' filename '_HL_Out.wav'],x_p(1,:),fs);

figure;
subplot(211); imagesc((1:NFrames)*N*Poverl/fs,[0 fs/2], abs(S)); axis xy;xlabel('Tiempo (s)');ylabel('Frecuencia (Hz)');
subplot(212); plot((1:NFrames)*N*Poverl/fs, sum(abs(Xc_r.^2)));xlabel('Tiempo (s)');ylabel('Frecuencia (Hz)');




% Clculo de Frecuencia Cardiaca

%Opcin 1
suma=0
auxiliar= sum(abs(Xc_r.^2))
auxiliar2=(1:NFrames)*N*Poverl/fs
ampd(sum(abs(Xc_r.^2)))

s=0
for i=2:NFrames-1
    if(auxiliar(i-1)<auxiliar(i) && auxiliar(i+1)<auxiliar(i) && auxiliar(i)>0.4)
        s=s+1
    end
end
FC1=s/2/auxiliar2(NFrames)*60;

%Opcion 2
tiempo1=0;
tiempo2=0;
cont=0;
suma=0;
for i=2:NFrames-1
    if(auxiliar(i-1)<auxiliar(i) && auxiliar(i+1)<auxiliar(i) && auxiliar(i)>2.5 && tiempo2~=0)
        tiempo1=tiempo2;
        tiempo2=auxiliar2(i);
        cont=cont+1;
        suma=suma+(tiempo2-tiempo1);
    end
    if (auxiliar(i-1)<auxiliar(i) && auxiliar(i+1)<auxiliar(i) && auxiliar(i)>2.5 && tiempo2==0)
            tiempo2=auxiliar2(i);
    end
end
FC2=60/(suma/cont);


%Opcion 3
SUME=sum(abs(Xc_r));
SUME_resampled = interp1(linspace(0,1,length(SUME)), SUME, (linspace(0,1,length(x))));
% Correlacion del ritmo cardiaco estimado
[Cx,lag]=xcorr(SUME_resampled); Cx=Cx(floor(length(Cx)/2):end);
lag=lag(floor(length(lag)/2):end);

% Definir l?mites de b?squeda para evitar esp?reos
BPM_min=40; %beat per minute minimum
BPM_max=190; %beat per minute maximum
T0_max_samp=floor((60/BPM_min)*fs);
T0_min_samp=floor((60/BPM_max)*fs);

% Ordenar los picos por prominencia de periodicidad, es decir, la cantidad de periodicidad mostrada
[PKS,LOCS]=findpeaks(Cx,'SortStr','descend'); 
 
% B?squeda del pico m?s prominente en el rango de BPM establecido
for i=1:length(LOCS)
     if ( (LOCS(i) > T0_min_samp) && (LOCS(i) < T0_max_samp) )
        break;
    end
end
 
% BPM estimado
BPM_estimado=round(60/(LOCS(i)/fs));

 figure;
 subplot(411);imagesc((1:NFrames)*N*Poverl/fs,[0 fs/2],abs(S));xlabel('Time (s)');axis xy;
 subplot(412);imagesc((1:NFrames)*N*Poverl/fs,[0 fs/2],abs(Xc_r));xlabel('Time (s)');axis xy;
 subplot(413);plot((1:length(SUME_resampled))/fs,SUME_resampled/max(SUME_resampled));xlabel('Time (s)');axis([])
 subplot(414);plot(lag/fs,Cx/max(Cx));hold on;plot(LOCS(i)/fs,Cx(LOCS(i))/max(Cx),'or');xlabel('Time (s)');axis([0 length(x)/fs 0 1]);axis xy;title(['Ritmo cardiaco estimado: ' num2str(BPM_estimado) ' BPM'])
